﻿{
function ConnectLayers()
{
var connectLayers,utils;
{
connectLayers = this;
utils = new ConnectLayersUtils();
this.scriptName = "ConnectLayers";
this.scriptVersion = "1.08";
this.scriptTitle = "Connect Layers";
this.scriptCopyright = "Copyright (c) 2013 Motion Boutique";
this.scriptHomepage = "www.motionboutique.com";
this.scriptDescription = {en:"This script connects the selected layers with segments or triangles created with shape layers.\\r\\rRope: creates a single shape layer with a path connecting the selected layers (2D only). Use AutoBezier or Tension options to get rounded joint style.\\r\\rTree: computes minimum spanning tree and draws each edge with a shape layer (2D and 3D support).\\r\\rTriangulation: triangulates the selected layers and draws each edge with a shape layer (2D and 3D support). If you want filled triangles (not just the edges), activate the Fill Triangles switch in the Options dialog. By default they will be filled with the same color, but you can also choose a source layer to colorize them.\\r\\rNote that for functions that create shape keyframes (Triangulation with Filled Triangles turned on, and Rope), keyframing is done within the comp work area.",fr:"Ce script relie les calques s\xe9lectionn\xe9s avec des segments ou des triangles cr\xe9\xe9s avec des calques de formes.\\r\\rCorde: cr\xe9e un calque de forme avec un trac\xe9 connectant les calques s\xe9lectionn\xe9s (2D seulement). Utilisez les options AutoBezier ou Tension pour avoir des joints arrondis.\\r\\rArbre: calcule un arbre couvrant minimum et dessine chaque ar\xeate avec un calque de forme (supporte 2D et 3D).\\r\\rTriangulation: triangule les calques s\xe9lectionn\xe9s et dessine chaque ar\xeate avec un calque de forme (supporte 2D and 3D). Si vous souhaitez des triangles remplis (pas seulement les ar\xeates), activez l\\'option Remplir les triangles dans le dialogue des options. Par d\xe9faut ils seront remplis en blanc, mais vous pouvez aussi choisir un calque source pour les colorer.\\r\\rNotez que pour les fonctions cr\xe9ant des images cl\xe9s pour le Trac\xe9 (Triangulation lorsque Remplir les triangles est coch\xe9 et Corde), la cr\xe9ation de cl\xe9s se fait sur la dur\xe9e de la zone de travail."};
this.scriptAbout = {en:(this.scriptName + ", v" + this.scriptVersion + "\\r" + this.scriptCopyright + "\\r" + this.scriptHomepage + "\\r\\r" + utils.loc(this.scriptDescription)),fr:(this.scriptName + ", v" + this.scriptVersion + "\\r" + this.scriptCopyright + "\\r" + this.scriptHomepage + "\\r\\r" + utils.loc(this.scriptDescription))};
this.scriptUsage = {en:"\u25ba Click on the function you want to execute\\r\u25ba Optionally, open the Options dialog to adjust parameters",fr:"\u25ba Cliquez sur la fonction \xe0 ex\xe9cuter\\r\u25ba Optionnellement ouvrez le dialogue des Options pour ajuster les param\xe8tres"};
this.headerImgFile = new File("(" + this.scriptName + "_Resources)/header.png");
this.optionsBtnName = {en:"Options",fr:"Options"};
this.aboutBtnName = "?";
this.ropeBtnName = {en:"Rope",fr:"Corde"};
this.treeBtnName = {en:"Tree",fr:"Arbre"};
this.triangulationBtnName = {en:"Triangulation",fr:"Triangulation"};
this.optionsTitle = {en:"Options",fr:"Options"};
this.optionsBtnHlp = {en:"Options...",fr:"Options..."};
this.aboutBtnHlp = {en:"About...",fr:"\xc0 propos de..."};
this.strokeGrpName = {en:"Stroke",fr:"Trait"};
this.strokeWidthStName = {en:"Stroke Width (px)",fr:"Largeur du trait (px)"};
this.strokeColorStName = {en:"Stroke Color",fr:"Couleur du trait"};
this.strokeWidthEtVal = 1;
this.strokeColorClrVal = [1,1,1];
this.ropeGrpName = {en:"Rope",fr:"Corde"};
this.autoBezierRbName = {en:"AutoBezier",fr:"AutoBezier"};
this.autoBezierRbVal = true;
this.tensionRbName = {en:"Tension (%)",fr:"Tension (%)"};
this.tensionRbVal = false;
this.tensionEtVal = 0;
this.closedCbName = {en:"Closed",fr:"Ferm\xe9"};
this.closedCbVal = false;
this.triangulationGrpName = {en:"Triangulation",fr:"Triangulation"};
this.fillTrianglesName = {en:"Fill Triangles",fr:"Remplir les triangles"};
this.fillTrianglesCbVal = false;
this.useColorsFromLayerCbName = {en:"Use Colors from Layer",fr:"Utiliser les couleurs du calque"};
this.useColorsFromLayerCbVal = false;
this.useColorsFromLayerId = 0;
this.refreshBtnName = {en:"Refresh",fr:"Rafra\xeechir"};
this.pgsBr = null;
this.optionsPal = null;
this.resErr = {en:("An error occurred when trying to load image resources. Make sure the '(" + this.scriptName) + "_Resources)' folder is located next to the script file.",fr:("Une erreur s'est produite lors de l'import des ressources image. Veuillez vous assurer que le dossier '(" + this.scriptName) + "_Resources)' est situ\xe9 \xe0 c\xf4t\xe9 du fichier du script."};
this.buildUI = function (thisObj)
{
var res,err,pal;
{
pal = (thisObj instanceof Panel)?thisObj:new Window("palette",this.scriptTitle,undefined,{resizeable:false});
pal.margins = 5;
res = ((((((((("group { orientation:'column', alignment:['left','top'], alignChildren:['right','top'], spacing:5, \n\t\t\tgr0: Group { alignment:['fill','fill'], \n\t\t\t\theader: Image { } \n\t\t\t}, \n\t\t\tgr1: Group { spacing:0, \n\t\t\t\toptionsBtn: Button { text:'" + utils.loc(this.optionsBtnName)) + "', preferredSize:[55,20] }, \n\t\t\t\taboutBtn: Button { text:'") + this.aboutBtnName) + "', preferredSize:[25,20] } \n\t\t\t}, \n\t\t\tgr2: Group { orientation:'row', alignment:['fill','top'], spacing:0, \n\t\t\t\tropeBtn: Button { text:'") + utils.loc(this.ropeBtnName)) + "', alignment:['fill','top'], preferredSize:[50,-1] }, \n\t\t\t\ttreeBtn: Button { text:'") + utils.loc(this.treeBtnName)) + "', alignment:['fill','top'], preferredSize:[50,-1] }, \n\t\t\t\ttriangulationBtn: Button { text:'") + utils.loc(this.triangulationBtnName)) + "', alignment:['fill','top'] } \n\t\t\t}, \n\t\t\tgr3: Group { orientation:'column', alignment:['fill','top'], \n\t\t\t\tpgsBr: Progressbar { alignment:['fill','top'], preferredSize:[-1,5] } \n\t\t\t} \n\t\t}";
pal.gr = pal.add(res);
connectLayers.pgsBr = pal.gr.gr3.pgsBr;
err = this.resErr;
try 
{
pal.gr.gr0.header.image = this.headerImgFile;
}

catch (e)
{
utils.throwErr(err);
}
pal.gr.gr1.aboutBtn.onClick = function ()
{
{
utils.createAboutDlg(connectLayers.scriptAbout,connectLayers.scriptUsage);
}
};
pal.gr.gr1.optionsBtn.onClick = function ()
{
var latestColorInt,res,optionsPal;
{
if(! connectLayers.optionsPal)
{
function populateLst()
{
var i,comp;
{
optionsPal.gr.gr2.gr22.gr221.useColorsFromLayerLst.removeAll();
comp = app.project.activeItem;
if(comp && (comp instanceof CompItem))
{
for (  i=1 ; i<=comp.numLayers ; i = i+1)
{
optionsPal.gr.gr2.gr22.gr221.useColorsFromLayerLst.add("item",comp.layer(i).name);
}
if(optionsPal.gr.gr2.gr22.gr221.useColorsFromLayerLst.items.length)
{
optionsPal.gr.gr2.gr22.gr221.useColorsFromLayerLst.selection = 0;
connectLayers.useColorsFromLayerId = 1;
}
}
}
}
optionsPal = new Window("palette",utils.loc(connectLayers.optionsTitle),undefined,{resizeable:false});
res = ((((((((((((((((((((((((((((((((((((((("group { orientation:'column', \n\t\t\t\t\tgr0: Panel { alignment:['fill','top'], \n\t\t\t\t\t\tgr01: Group { alignment:['fill','top'], \n\t\t\t\t\t\t\tstrokeWidthSt: StaticText { text:'" + utils.loc(connectLayers.strokeWidthStName)) + "', alignment:['left','top'] }, \n\t\t\t\t\t\t\tstrokeWidthEt: EditText { text:'") + connectLayers.strokeWidthEtVal) + "', preferredSize:[65,20], alignment:['right','top'] } \n\t\t\t\t\t\t}, \n\t\t\t\t\t\tgr02: Group { alignment:['fill','top'], \n\t\t\t\t\t\t\tstrokeColorSt: StaticText { text:'") + utils.loc(connectLayers.strokeColorStName)) + "', alignment:['left','top'] }, \n\t\t\t\t\t\t\tgr021: Group { alignment:['right','top'], orientation:'stack', margins:[0,0,1,0], \n\t\t\t\t\t\t\t\tcoloredGrp: Group { preferredSize:[65,20], alignment:['center','center'] }, \n\t\t\t\t\t\t\t\tcolorPickerBtn: IconButton { preferredSize:[12,7], alignment:['center','center'] } \n\t\t\t\t\t\t\t} \n\t\t\t\t\t\t} \n\t\t\t\t\t}, \n\t\t\t\t\tgr1: Panel { text:'") + utils.loc(connectLayers.ropeGrpName)) + "', alignment:['fill','top'], \n\t\t\t\t\t\tgr11: Group { alignment:['fill','top'], \n\t\t\t\t\t\t\tautoBezierRb: RadioButton { text:'") + utils.loc(connectLayers.autoBezierRbName)) + "', value:") + connectLayers.autoBezierRbVal) + ", alignment:['left','top'] } \n\t\t\t\t\t\t}, \n\t\t\t\t\t\tgr12: Group { alignment:['fill','top'], \n\t\t\t\t\t\t\ttensionRb: RadioButton { text:'") + utils.loc(connectLayers.tensionRbName)) + "', value:") + connectLayers.tensionRbVal) + ", alignment:['left','top'] }, \n\t\t\t\t\t\t\ttensionEt: EditText { text:'") + connectLayers.tensionEtVal) + "', preferredSize:[65,20], enabled:") + connectLayers.tensionRbVal) + ", alignment:['right','top'] } \n\t\t\t\t\t\t}, \n\t\t\t\t\t\tgr13: Group { alignment:['fill','top'], \n\t\t\t\t\t\t\tclosedCb: Checkbox { text:'") + utils.loc(connectLayers.closedCbName)) + "', value:") + connectLayers.closedCbVal) + ", alignment:['left','top'] } \n\t\t\t\t\t\t} \n\t\t\t\t\t}, \n\t\t\t\t\tgr2: Panel { text:'") + utils.loc(connectLayers.triangulationGrpName)) + "', alignment:['fill','top'], \n\t\t\t\t\t\tgr21: Group { alignment:['fill','top'], \n\t\t\t\t\t\t\tfillTrianglesCb: Checkbox { text:'") + utils.loc(connectLayers.fillTrianglesName)) + "', value:") + connectLayers.fillTrianglesCbVal) + ", alignment:['left','top'] } \n\t\t\t\t\t\t} \n\t\t\t\t\t\tgr22: Group { alignment:['fill','top'], orientation:'column', spacing:0, \n\t\t\t\t\t\t\tuseColorsFromLayerCb: Checkbox { text:'") + utils.loc(connectLayers.useColorsFromLayerCbName)) + "', value:") + connectLayers.useColorsFromLayerCbVal) + ", alignment:['left','top'] } \n\t\t\t\t\t\t\tgr221: Group { alignment:['fill','top'], orientation:'row', spacing:0, \n\t\t\t\t\t\t\t\tuseColorsFromLayerLst: DropDownList { preferredSize:[95,20], alignment:['fill','top'], enabled:") + connectLayers.useColorsFromLayerCbVal) + " }, \n\t\t\t\t\t\t\t\trefreshBtn: Button { text:'") + utils.loc(connectLayers.refreshBtnName)) + "', preferredSize:[65,20], alignment:['right','top'], enabled:") + connectLayers.useColorsFromLayerCbVal) + " } \n\t\t\t\t\t\t\t} \n\t\t\t\t\t\t} \n\t\t\t\t\t} \n\t\t\t\t};";
optionsPal.gr = optionsPal.add(res);
if(connectLayers.useColorsFromLayerId)
{
optionsPal.gr.gr2.gr22.gr221.useColorsFromLayerLst.selection = connectLayers.useColorsFromLayerId;
}
latestColorInt = 255 * (((0x10000 * connectLayers.strokeColorClrVal[0]) + (256 * connectLayers.strokeColorClrVal[1])) + connectLayers.strokeColorClrVal[2]);
optionsPal.gr.gr0.gr02.gr021.coloredGrp.graphics.backgroundColor = optionsPal.graphics.newBrush(optionsPal.graphics.BrushType.SOLID_COLOR,[connectLayers.strokeColorClrVal[0],connectLayers.strokeColorClrVal[1],connectLayers.strokeColorClrVal[2],1]);
populateLst();
optionsPal.gr.gr0.gr01.strokeWidthEt.onChange = function ()
{
{
if(isNaN(parseFloat(this.text)))
this.text = 1;
connectLayers.strokeWidthEtVal = parseFloat(this.text);
}
};
optionsPal.gr.gr0.gr02.gr021.colorPickerBtn.onClick = function ()
{
var r,b,g,c;
{
this.value = false;
c = $.colorPicker(latestColorInt);
if(c == -1)
return  ;
r = ((c >> 16) & 255) / 255;
g = ((c >> 8) & 255) / 255;
b = (c & 255) / 255;
latestColorInt = c;
optionsPal.gr.gr0.gr02.gr021.coloredGrp.graphics.backgroundColor = optionsPal.graphics.newBrush(pal.graphics.BrushType.SOLID_COLOR,[r,g,b,1]);
connectLayers.strokeColorClrVal = [r,g,b];
}
};
optionsPal.gr.gr1.gr11.autoBezierRb.onClick = function ()
{
connectLayers.autoBezierRbVal = this.value;
connectLayers.tensionRbVal = ! this.value;
optionsPal.gr.gr1.gr12.tensionRb.value = ! this.value;
optionsPal.gr.gr1.gr12.tensionEt.enabled = ! this.value;
};
optionsPal.gr.gr1.gr12.tensionRb.onClick = function ()
{
connectLayers.autoBezierRbVal = ! this.value;
connectLayers.tensionRbVal = this.value;
optionsPal.gr.gr1.gr11.autoBezierRb.value = ! this.value;
optionsPal.gr.gr1.gr12.tensionEt.enabled = this.value;
};
optionsPal.gr.gr1.gr12.tensionEt.onChange = function ()
{
{
if(isNaN(parseFloat(this.text)))
this.text = 0;
connectLayers.tensionEtVal = parseInt(this.text) / 200;
}
};
optionsPal.gr.gr1.gr13.closedCb.onClick = function ()
{
connectLayers.closedCbVal = this.value;
};
optionsPal.gr.gr2.gr21.fillTrianglesCb.onClick = function ()
{
{
connectLayers.fillTrianglesCbVal = this.value;
if(! this.value)
{
optionsPal.gr.gr2.gr22.useColorsFromLayerCb.value = false;
optionsPal.gr.gr2.gr22.gr221.useColorsFromLayerLst.enabled = false;
optionsPal.gr.gr2.gr22.gr221.refreshBtn.enabled = false;
connectLayers.fillTrianglesCbVal = false;
}
}
};
optionsPal.gr.gr2.gr22.useColorsFromLayerCb.onClick = function ()
{
{
this.parent.gr221.useColorsFromLayerLst.enabled = this.value;
this.parent.gr221.refreshBtn.enabled = this.value;
connectLayers.useColorsFromLayerCbVal = this.value;
if(this.value)
{
optionsPal.gr.gr2.gr21.fillTrianglesCb.value = true;
connectLayers.fillTrianglesCbVal = true;
}
}
};
optionsPal.gr.gr2.gr22.gr221.useColorsFromLayerLst.onChange = function ()
{
{
connectLayers.useColorsFromLayerId = this.selection.index + 1;
}
};
optionsPal.gr.gr2.gr22.gr221.refreshBtn.onClick = function ()
{
var comp;
{
comp = app.project.activeItem;
if(comp && (comp instanceof CompItem))
{
populateLst();
if(optionsPal.gr.gr2.gr22.gr221.useColorsFromLayerLst.items.length)
{
optionsPal.gr.gr2.gr22.gr221.useColorsFromLayerLst.selection = 0;
}
}
else
{
alert("You must select a comp first.");
}
}
}
;
connectLayers.optionsPal = optionsPal;
}
connectLayers.optionsPal.center();
connectLayers.optionsPal.show();
}
};
pal.gr.gr2.ropeBtn.onClick = function ()
{
{
connectLayers.doRope();
}
}
;
pal.gr.gr2.treeBtn.onClick = function ()
{
connectLayers.doTree();
};
pal.gr.gr2.triangulationBtn.onClick = function ()
{
connectLayers.doTriangulation();
};
if(pal instanceof Window)
{
pal.center();
pal.show();
}
else
{
pal.layout.layout(true);
}
}
};
this.doRope = function ()
{
new Rope(this.strokeWidthEtVal,this.strokeColorClrVal,this.autoBezierRbVal,this.tensionRbVal,this.tensionEtVal,this.closedCbVal,this.pgsBr).run();
};
this.doTree = function ()
{
new SpanningTree(this.strokeWidthEtVal,this.strokeColorClrVal,this.pgsBr).run();
};
this.doTriangulation = function ()
{
new DelaunayTriangulation(this.strokeWidthEtVal,this.strokeColorClrVal,this.fillTrianglesCbVal,this.useColorsFromLayerCbVal,this.useColorsFromLayerId,this.pgsBr).run();
};
this.run = function (thisObj)
{
{
this.buildUI(thisObj);
}
}
;
}
}
function Rope(strokeWidth,strokeColor,autoBezier,customTension,tensionFactor,isClosed,pgsBr)
{
var utils,simpleConnection;
{
simpleConnection = this;
utils = new ConnectLayersUtils();
this.epsilon = 0.001;
this.createJoints = function (comp,layers)
{
var i,j,start,end,t,str,path,step,shapes,keyTimes,isSafeB,verts,pt,shape,inTangents,outTangents,u,shapeLayer,rootVectorsGroup,shapeProp,stroke,layer,strokeColorProp,strokeWidthProp;
{
start = comp.workAreaStart;
end = start + comp.workAreaDuration;
step = comp.frameDuration;
shapes = [];
keyTimes = [];
pgsBr.minvalue = 0;
pgsBr.maxvalue = Math.floor(((end - this.epsilon) - start) / step);
pgsBr.value = 0;
isSafeB = true;
if(((end - start) * layers.length) > 100)
{
str = {en:"The script is going to create many keyframes, and this operation might be slow. Note that comp work area is taken into account when keyframing. Would you like to continue ?",fr:"Le script s'appr\xeate \xe0 cr\xe9er de nombreuses images cl\xe9s et cette op\xe9ration pourrait \xeatre longue. Notez que la zone de travail est prise en compte lors de la cr\xe9ation de cl\xe9s. Souhaitez-vous continuer ?"};
isSafeB = confirm(utils.loc(str));
if(! isSafeB)
{
return  ;
}
}
for(t = start;t <= (end - this.epsilon);t += step)
{
pgsBr.value++;
try 
{
if(pgsBr.parent.parent.parent instanceof Window)
pgsBr.parent.parent.parent.update();
writeLn("Frame " + pgsBr.value + "/" + pgsBr.maxvalue);
}

catch (e)
{}
verts = [];
for (  i=0 ; i<layers.length ; i = i+1)
{
layer = layers[i];
pt = toWorld(layer,layer.anchorPoint.valueAtTime(t,false),t);
verts.push([pt[0],pt[1]]);
}
keyTimes.push(t);
shape = new Shape();
shape.vertices = verts;
if(customTension)
{
inTangents = [];
outTangents = [];
if(! isClosed)
{
inTangents.push([0,0]);
outTangents.push([0,0]);
}
else
{
u = verts[1] - verts[verts.length - 1];
inTangents.push(- tensionFactor * u);
outTangents.push(tensionFactor * u);
}
for (  j=1 ; j<verts.length - 1 ; j = j+1)
{
u = verts[j + 1] - verts[j - 1];
inTangents.push(- tensionFactor * u);
outTangents.push(tensionFactor * u);
}
if(! isClosed)
{
inTangents.push([0,0]);
outTangents.push([0,0]);
}
else
{
u = verts[0] - verts[verts.length - 2];
inTangents.push(- tensionFactor * u);
outTangents.push(tensionFactor * u);
}
shape.inTangents = inTangents;
shape.outTangents = outTangents;
}
else
if(autoBezier)
{
inTangents = [];
for (  j=0 ; j<verts.length ; j = j+1)
{
inTangents.push([this.epsilon,this.epsilon]);
}
shape.inTangents = inTangents;
}
shape.closed = isClosed;
shapes.push(shape);
}
shapeLayer = comp.layers.addShape();
shapeLayer.name = ("Rope  [" + (0x186A0 * Math.random()).toFixed(0)) + "]";
rootVectorsGroup = shapeLayer.property("ADBE Root Vectors Group");
path = rootVectorsGroup.addProperty("ADBE Vector Shape - Group");
shapeProp = path.property("ADBE Vector Shape");
shapeProp.setValuesAtTimes(keyTimes,shapes);
if(autoBezier)
{
path.selected = true;
app.executeCommand(app.findMenuCommandId("RotoBezier"));
}
stroke = rootVectorsGroup.addProperty("ADBE Vector Graphic - Stroke");
strokeColorProp = stroke.property("ADBE Vector Stroke Color");
strokeColorProp.setValue(strokeColor);
strokeWidthProp = stroke.property("ADBE Vector Stroke Width");
strokeWidthProp.setValue(strokeWidth);
shapeLayer.position.setValue([0,0]);
pgsBr.value = 0;
}
};
this.run = function ()
{
var i,comp,layers,areLayers2D,err;
{
comp = app.project.activeItem;
err = {en:"Select at least two layers.",fr:"S\xe9lectionez au moins deux calques"};
if(! comp || ! (comp instanceof CompItem))
{
utils.throwErr(err);
return  ;
}
layers = comp.selectedLayers;
if(layers.length < 2)
{
utils.throwErr(err);
return  ;
}
err = {en:"Selected layers must be 2D layers.",fr:"Les calques s\xe9lectionn\xe9s doivent \xeatre des calques 2D."};
areLayers2D = true;
for(i = 0;areLayers2D && (i < layers.length);i++)
{
if(layers[i].threeDLayer)
{
areLayers2D = false;
}
}
if(! areLayers2D)
{
utils.throwErr(err);
return  ;
}
try 
{
app.beginUndoGroup("Rope");
this.createJoints(comp,layers);
app.endUndoGroup();
}

catch (e)
{
alert(e);
}
}
};
}
}
function DelaunayTriangulation(strokeWidth,strokeColor,fillTrianglesB,useColorsFromLayerB,useColorsFromLayerId,pgsBr)
{
var utils;
{
utils = new ConnectLayersUtils();
this.pts = [];
this.Triangle = function (a,b,c)
{
var A,B,C,D,F,G,minx,E,miny,dx,dy;
{
this.a = a;
this.b = b;
this.c = c;
{
A = b.x - a.x;
B = b.y - a.y;
C = c.x - a.x;
D = c.y - a.y;
E = (A * (a.x + b.x)) + (B * (a.y + b.y));
F = (C * (a.x + c.x)) + (D * (a.y + c.y));
G = 2 * ((A * (c.y - b.y)) - (B * (c.x - b.x)));
}
if(Math.abs(G) < 0.000001)
{
minx = Math.min(a.x,b.x,c.x);
miny = Math.min(a.y,b.y,c.y);
dx = (Math.max(a.x,b.x,c.x) - minx) * 0.5;
dy = (Math.max(a.y,b.y,c.y) - miny) * 0.5;
this.x = minx + dx;
this.y = miny + dy;
this.r = (dx * dx) + (dy * dy);
}
else
{
this.x = ((D * E) - (B * F)) / G;
this.y = ((A * F) - (C * E)) / G;
dx = this.x - a.x;
dy = this.y - a.y;
this.r = (dx * dx) + (dy * dy);
}
}
};
this.byX = function (a,b)
{
{
return  b.x - a.x;
}
};
this.dedup = function (edges)
{
var i,j,a,b,n,m;
{
j = edges.length;
outer:
while (j)
{
b = edges[--j];
a = edges[--j];
i = j;
while (i)
{
n = edges[--i];
m = edges[--i];
if(((a === m) && (b === n)) || ((a === n) && (b === m)))
{
edges.splice(j,2);
edges.splice(i,2);
j -= 2;
continue outer;
}
}
}
}
};
this.triangulate = function (vertices)
{
var i,j,open,dx,dy,edges,xmin,xmax,ymin,ymax,dmax,closed,xmid,a,ymid,b;
{
if(vertices.length < 3)
return  [];
vertices.sort(this.byX);
{
i = vertices.length - 1;
xmin = vertices[i].x;
xmax = vertices[0].x;
ymin = vertices[i].y;
ymax = ymin;
}
while (i--)
{
if(vertices[i].y < ymin)
ymin = vertices[i].y;
if(vertices[i].y > ymax)
ymax = vertices[i].y;
}
{
dx = xmax - xmin;
dy = ymax - ymin;
dmax = (dx > dy)?dx:dy;
xmid = (xmax + xmin) * 0.5;
ymid = (ymax + ymin) * 0.5;
open = [new this.Triangle({x:xmid - (20 * dmax),y:ymid - dmax,__sentinel:true},{x:xmid,y:ymid + (20 * dmax),__sentinel:true},{x:xmid + (20 * dmax),y:ymid - dmax,__sentinel:true})];
closed = [];
edges = [];
}
i = vertices.length;
while (i--)
{
edges.length = 0;
j = open.length;
while (j--)
{
dx = vertices[i].x - open[j].x;
if((dx > 0) && ((dx * dx) > open[j].r))
{
closed.push(open[j]);
open.splice(j,1);
continue ;
}
dy = vertices[i].y - open[j].y;
if(((dx * dx) + (dy * dy)) > open[j].r)
continue ;
edges.push(open[j].a,open[j].b,open[j].b,open[j].c,open[j].c,open[j].a);
open.splice(j,1);
}
this.dedup(edges);
j = edges.length;
while (j)
{
b = edges[--j];
a = edges[--j];
open.push(new this.Triangle(a,b,vertices[i]));
}
}
Array.prototype.push.apply(closed,open);
i = closed.length;
while (i--)
if((closed[i].a.__sentinel || closed[i].b.__sentinel) || closed[i].c.__sentinel)
closed.splice(i,1);
return  closed;
}
};
this.findLayerFromPoint = function (layers,point)
{
var i,layer,layerPos;
{
for (  i=0 ; i<layers.length ; i = i+1)
{
layer = layers[i];
layerPos = this.pts[i];
if((Math.abs(layerPos[0] - point.x) < 0.005000) && (Math.abs(layerPos[1] - point.y) < 0.005000))
{
return  layer;
}
}
}
};
this.containsEdge = function (edgeArray,edge)
{
var i,isIn;
{
isIn = false;
for(i = 0;! isIn && (i < edgeArray.length);i++)
{
if(((edgeArray[i][0] == edge[0]) && (edgeArray[i][1] == edge[1])) || ((edgeArray[i][0] == edge[1]) && (edgeArray[i][1] == edge[0])))
{
isIn = true;
}
}
return  isIn;
}
};
this.createJoints = function (comp,layers)
{
var i,start,end,str,err,triangles,isSafeB,useColorsFromLayerName,tabuEdges,tri,pt,layerA,layerB,layerC,e1,e2,e3,vertices,layer;
{
this.pts = [];
vertices = new Array(layers.length);
for (  i=0 ; i<layers.length ; i = i+1)
{
layer = layers[i];
pt = toWorld(layer,layer.anchorPoint.valueAtTime(comp.time,false),comp.time);
this.pts.push(pt);
vertices[i] = {x:pt[0],y:pt[1]};
}
if(vertices.length == 2)
{
utils.createJoint(comp,layers[0].name,layers[1].name);
}
else
{
triangles = this.triangulate(vertices);
if(triangles.length == 0)
{
err = {en:"Error occurred when triangulating selected layers (aligned layers?).",fr:"Une erreur est survenue lors de la triangulation des calques s\xe9lectionn\xe9s (calques align\xe9s ?)"};
utils.throwErr(err);
return  ;
}
pgsBr.minvalue = 0;
pgsBr.maxvalue = triangles.length;
pgsBr.value = 0;
if(fillTrianglesB)
{
isSafeB = true;
start = comp.workAreaStart;
end = start + comp.workAreaDuration;
if(((end - start) * layers.length) > 100)
{
str = {en:"The script is going to create many keyframes, and this operation might be slow. Note that comp work area is taken into account when keyframing. Would you like to continue ?",fr:"Le script s'appr\xeate \xe0 cr\xe9er de nombreuses images cl\xe9s et cette op\xe9ration pourrait \xeatre longue. Notez que la zone de travail est prise en compte lors de la cr\xe9ation de cl\xe9s. Souhaitez-vous continuer ?"};
isSafeB = confirm(utils.loc(str));
if(! isSafeB)
{
return  ;
}
}
}
tabuEdges = [];
for (  i=0 ; i<triangles.length ; i = i+1)
{
pgsBr.value++;
try 
{
if(pgsBr.parent.parent.parent instanceof Window)
pgsBr.parent.parent.parent.update();
writeLn((("Triangle " + pgsBr.value) + "/") + pgsBr.maxvalue);
}

catch (e)
{}
tri = triangles[i];
layerA = this.findLayerFromPoint(layers,tri.a);
layerB = this.findLayerFromPoint(layers,tri.b);
layerC = this.findLayerFromPoint(layers,tri.c);
if(fillTrianglesB)
{
if(i == 0)
{
useColorsFromLayerName = useColorsFromLayerB?comp.layer(useColorsFromLayerId).name:null;
}
utils.createTriangle(strokeWidth,strokeColor,useColorsFromLayerB,useColorsFromLayerName,comp,layerA,layerB,layerC);
}
else
{
e1 = [layerA.name,layerB.name];
e2 = [layerB.name,layerC.name];
e3 = [layerC.name,layerA.name];
if(! this.containsEdge(tabuEdges,e1))
{
utils.createJoint(strokeWidth,strokeColor,comp,layerA.name,layerB.name);
tabuEdges.push(e1);
}
if(! this.containsEdge(tabuEdges,e2))
{
utils.createJoint(strokeWidth,strokeColor,comp,layerB.name,layerC.name);
tabuEdges.push(e2);
}
if(! this.containsEdge(tabuEdges,e3))
{
utils.createJoint(strokeWidth,strokeColor,comp,layerC.name,layerA.name);
tabuEdges.push(e3);
}
}
}
pgsBr.value = 0;
}
}
};
this.run = function ()
{
var comp,layers,err;
{
comp = app.project.activeItem;
err = {en:"Select at least two layers.",fr:"S\xe9lectionez au moins deux calques"};
if(! comp || ! (comp instanceof CompItem))
{
utils.throwErr(err);
return  ;
}
layers = comp.selectedLayers;
if(layers.length < 2)
{
utils.throwErr(err);
return  ;
}
utils.autoRenameLayers(comp);
try 
{
app.beginUndoGroup("Delaunay Triangulation");
this.createJoints(comp,layers);
app.endUndoGroup();
}

catch (e)
{
alert(e);
}
}
};
}
}
function SpanningTree(strokeWidth,strokeColor,pgsBr)
{
var spanningTree,utils;
{
spanningTree = this;
utils = new ConnectLayersUtils();
this.getLength = function (u)
{
{
return  Math.sqrt(((u.x * u.x) + (u.y * u.y)) + (u.z * u.z));
}
};
this.Point = function (x,y,z,name)
{
{
this.x = x;
this.y = y;
this.z = z;
this.name = name;
}
};
this.Edge = function (a,b)
{
{
this.a = a;
this.b = b;
this.cost = spanningTree.getLength(new spanningTree.Point(b.x - a.x,b.y - a.y,b.z - a.z,""));
}
};
this.byCost = function (e1,e2)
{
{
return  e1.cost - e2.cost;
}
};
this.contain = function (component,name)
{
var i,found;
{
found = false;
for(i = 0;! found && (i < component.length);i++)
{
if(component[i].name == name)
{
found = true;
}
}
return  found;
}
};
this.doesEdgeConnectTwoDifferentComponents = function (components,edge)
{
var i,component,connectB;
{
connectB = false;
for(i = 0;! connectB && (i < components.length);i++)
{
component = components[i];
if((this.contain(component,edge.a.name) && ! this.contain(component,edge.b.name)) || (! this.contain(component,edge.a.name) && this.contain(component,edge.b.name)))
{
connectB = true;
}
}
return  connectB;
}
};
this.getComponentIndexFromPoint = function (components,point)
{
var i,component,idx;
{
idx = -1;
for(i = 0;(idx == -1) && (i < components.length);i++)
{
component = components[i];
if(this.contain(component,point.name))
{
idx = i;
}
}
return  idx;
}
};
this.mergeComponents = function (components,edge)
{
var i,j,k;
{
i = this.getComponentIndexFromPoint(components,edge.a);
j = this.getComponentIndexFromPoint(components,edge.b);
for (  k=0 ; k<components[j].length ; k = k+1)
{
components[i].push(components[j][k]);
}
components.splice(j,1);
return  components;
}
};
this.createJoints = function (comp,layers)
{
var i,pts,pt,j,p,edges,component,components,tree,layer,tabuNodes,edge,n;
{
n = layers.length;
edges = [];
pts = [];
for (  i=0 ; i<n ; i = i+1)
{
layer = layers[i];
p = toWorld(layer,layer.anchorPoint.valueAtTime(comp.time,false),comp.time);
if(p.length == 2)
p.push(0);
pt = new this.Point(p[0],p[1],p[2],layer.name);
pts.push(pt);
}
for (  i=0 ; i<n - 1 ; i = i+1)
{
for(j = i + 1;j < n;j++)
{
edge = new this.Edge(pts[i],pts[j]);
edges.push(edge);
}
}
edges.sort(this.byCost);
components = [];
for (  i=0 ; i<n ; i = i+1)
{
component = [];
component.push(pts[i]);
components.push(component);
}
tree = [];
tabuNodes = [];
for (  i=0 ; i<edges.length ; i = i+1)
{
edge = edges[i];
if(this.doesEdgeConnectTwoDifferentComponents(components,edge))
{
tree.push(edge);
components = this.mergeComponents(components,edge);
if(tree.length == (n - 1))
break ;
}
}
pgsBr.minvalue = 0;
pgsBr.maxvalue = tree.length;
pgsBr.value = 0;
for (  i=0 ; i<tree.length ; i = i+1)
{
pgsBr.value++;
try 
{
if(pgsBr.parent.parent.parent instanceof Window)
pgsBr.parent.parent.parent.update();
writeLn((("Edge " + pgsBr.value) + "/") + pgsBr.maxvalue);
}

catch (e)
{}
utils.createJoint(strokeWidth,strokeColor,comp,tree[i].a.name,tree[i].b.name);
}
pgsBr.value = 0;
}
};
this.run = function ()
{
var comp,layers,err;
{
comp = app.project.activeItem;
err = {en:"Select at least two layers.",fr:"S\xe9lectionez au moins deux calques"};
if(! comp || ! (comp instanceof CompItem))
{
utils.throwErr(err);
return  ;
}
layers = comp.selectedLayers;
if(layers.length < 2)
{
utils.throwErr(err);
return  ;
}
utils.autoRenameLayers(comp);
try 
{
app.beginUndoGroup("Spanning Tree");
this.createJoints(comp,layers);
app.endUndoGroup();
}

catch (e)
{
alert(e);
}
}
};
}
}
function ConnectLayersUtils()
{
var utils;
{
utils = this;
this.loc = function (str)
{
var localLang;
{
localLang = (parseFloat(app.version) < 9)?$.locale:app.isoLanguage;
return  localLang.toLowerCase().match("fr")?str.fr:str.en;
}
};
this.throwErr = function (err)
{
{
alert(this.loc(err),"Error",true);
}
};
this.isInArray = function (array,element)
{
var i,found;
{
found = false;
for(i = 0;! found && (i < array.length);i++)
{
if(array[i] == element)
found = true;
}
return  found;
}
};
this.autoRenameLayers = function (comp)
{
var affectedIndices,reportInfo,i,j,msg,layers,elementsRenameMsg,originalNames;
{
elementsRenameMsg = {en:"To avoid confusion the script has renamed the following elements by adding an appropriate number of trailing blank character to the original element name:\r\r%s",fr:"Afin d'\xe9viter la confusion le script a renomm\xe9 les \xe9l\xe9ments suivants en ajoutant un nombre appropri\xe9 de caract\xe8res blanc \xe0 la fin du nom initial de l'\xe9l\xe9ment:\r\r"};
layers = comp.layers;
originalNames = new Array();
affectedIndices = new Array();
for (  i=1 ; i<=layers.length ; i = i+1)
originalNames.push(layers[i].name);
for (  i=1 ; i<=layers.length - 1 ; i = i+1)
for(j = i + 1;j <= layers.length;j++)
if(layers[i].name == layers[j].name)
{
if(! this.isInArray(affectedIndices,j))
affectedIndices.push(j);
layers[j].name += " ";
}
reportInfo = "";
for (  i=0 ; i<affectedIndices.length ; i = i+1)
reportInfo += (((("\tLayer " + affectedIndices[i]) + ": ") + originalNames[affectedIndices[i] - 1]) + "\r");
if(reportInfo.length)
{
msg = elementsRenameMsg;
msg.en = this.loc(msg).replace("%s",reportInfo);
msg.fr = this.loc(msg).replace("%s",reportInfo);
}
}
};
this.createJoint = function (strokeWidth,strokeColor,comp,layerAName,layerBName)
{
var is3D,rootVectorsGrp,vectorGrp,rectPath,rectSizeProp,trim,trimEndProp,trimStartProp,shapeLayer,stroke,strokeColorProp,strokeWidthProp;
{
shapeLayer = comp.layers.addShape();
shapeLayer.name = (("Joint " + layerAName) + " - ") + layerBName;
is3D = comp.layer(layerAName).threeDLayer && comp.layer(layerBName).threeDLayer;
if(is3D)
shapeLayer.threeDLayer = true;
rootVectorsGrp = shapeLayer.property("ADBE Root Vectors Group");
vectorGrp = rootVectorsGrp.addProperty("ADBE Vector Group");
vectorGrp.name = "Joint";
rectPath = vectorGrp.property("ADBE Vectors Group").addProperty("ADBE Vector Shape - Rect");
rectPath.name = "Joint Path";
rectSizeProp = rectPath.property("ADBE Vector Rect Size");
rectSizeProp.expression = (((((((("strokeW = 1;\rL1 = thisComp.layer(\"" + layerAName) + "\");\r") + "L2 = thisComp.layer(\"") + layerBName) + "\");\r") + "p1 = L1.toWorld(L1.anchorPoint);\r") + "p2 = L2.toWorld(L2.anchorPoint);\r") + "dist = length(p2-p1);\r") + "[dist, strokeW];";
stroke = vectorGrp.property("ADBE Vectors Group").addProperty("ADBE Vector Graphic - Stroke");
stroke.name = "Stroke";
strokeColorProp = stroke.property("ADBE Vector Stroke Color");
strokeColorProp.setValue(strokeColor);
strokeWidthProp = stroke.property("ADBE Vector Stroke Width");
strokeWidthProp.setValue(strokeWidth);
trim = vectorGrp.property("ADBE Vectors Group").addProperty("ADBE Vector Filter - Trim");
trim.name = "Trim Path";
trimEndProp = trim.property("ADBE Vector Trim End");
trimEndProp.setValue(50);
trimStartProp = trim.property("ADBE Vector Trim Start");
trimStartProp.expression = "L = content(\"Joint\").content(\"Joint Path\").size[0];\rl = content(\"Joint\").content(\"Joint Path\").size[1];\r1e-6 + 100* (l / (2*(L+l)));";
shapeLayer.anchorPoint.expression = "s = content(\"Joint\").content(\"Joint Path\").size;\r[-s[0]/2,0,0];";
shapeLayer.position.expression = (("L1 = thisComp.layer(\"" + layerAName) + "\");\r") + "p1 = L1.toWorld(L1.anchorPoint);";
if(is3D)
{
shapeLayer.orientation.expression = (((((((((((((((((("function angleBetween(v1, v2)\r{\rvar n = length(v1) * length(v2);\rreturn n == 0 ? 0 : radiansToDegrees(Math.acos(clamp(dot(v1, v2), -1, 1) / n));\r}\rfunction toEuler(x, y, z, angle)\r{\rvar bank, heading, attitude; // rotx, roty, rotz\rvar s = Math.sin(angle);\rvar c = Math.cos(angle);\rvar t = 1-c;\rif ((x*y*t + z*s) > 0.9999)\r{\rheading = 2*Math.atan2(x*Math.sin(angle/2),Math.cos(angle/2));\rattitude = Math.PI/2;\rbank = 0;\r}\relse if ((x*y*t + z*s) < -0.9999)\r{\rheading = -2*Math.atan2(x*Math.sin(angle/2),Math.cos(angle/2));\rattitude = -Math.PI/2;\rbank = 0;\r}\relse\r{\rheading = Math.atan2(y * s- x * z * t , 1 - (y*y+ z*z ) * t);\rattitude = Math.asin(x * y * t + z * s);\rbank = Math.atan2(x * s - y * z * t , 1 - (x*x + z*z) * t);\r}\rreturn [bank, heading, attitude];\r}\rtry{\rL1 = thisComp.layer(\"" + layerAName) + "\");\r") + "L2 = thisComp.layer(\"") + layerBName) + "\");\r") + "compPar = thisComp.pixelAspect;\r") + "A = L1.toWorld(L1.anchorPoint);\r") + "B = L2.toWorld(L2.anchorPoint);\r") + "u = normalize(toWorldVec([1,0,0]));\r") + "temp = [ (B[0]-A[0])*compPar,  B[1]-A[1], B[2]-A[2] ];\r") + "v = normalize(temp);\r") + "angle = angleBetween(u,v);\r") + "axis = cross(u,v);\r") + "if (axis[0] == 0 && axis[1] == 0 && axis[2] == 0) axis = [0,1,0];\r") + "axis = normalize(axis);\r") + "rots = toEuler(axis[0],axis[1],axis[2], degreesToRadians(angle));\r") + "[0, radiansToDegrees(rots[1]), radiansToDegrees(rots[2])];\r") + "}\r") + "catch(e){ value; }";
}
else
{
shapeLayer.rotation.expression = (((((((((((("L1 = thisComp.layer(\"" + layerAName) + "\");\r") + "L2 = thisComp.layer(\"") + layerBName) + "\");\r") + "try\r") + "{\r") + "   p1 = L1.toWorld(L1.anchorPoint);\r") + "   p2 = L2.toWorld(L2.anchorPoint);\r") + "   u = p2-p1;\r") + "   a = Math.atan2(u[1],u[0]);\r") + "   radiansToDegrees(a);\r") + "}catch(e){value;}";
}
}
};
this.createTriangle = function (strokeWidth,strokeColor,useColorsFromLayerB,useColorsFromLayerName,comp,layerA,layerB,layerC)
{
var is3D,t,pos,contentGrp,shapeGrp,contentsGrp,pt3d,pt3dProp,pathGrp,pathProp,keyShapeValues,keyPosValues,startT,endT,v0,v1,v2,strokeGrp,fillGrp,fillColorProp,keyTimes,verts,shape,shapeLayer,strokeWidthProp;
{
is3D = (layerA.threeDLayer || layerB.threeDLayer) || layerC.threeDLayer;
shapeLayer = comp.layers.addShape();
shapeLayer.name = ("Triangle  [" + (0x186A0 * Math.random()).toFixed(0)) + "]";
shapeLayer.threeDLayer = is3D;
if(is3D)
{
shapeLayer.orientation.expression = (((((((((((("LA = thisComp.layer(\"" + layerA.name) + "\");\r") + "LB = thisComp.layer(\"") + layerB.name) + "\");\r") + "LC = thisComp.layer(\"") + layerC.name) + "\");\r") + "a = LA.toWorld(LA.anchorPoint);\r") + "b = LB.toWorld(LB.anchorPoint);\r") + "c = LC.toWorld(LC.anchorPoint);\r") + "n = cross(b-a, c-a);\r") + "lookAt(position,position+n);";
}
contentGrp = shapeLayer.property("ADBE Root Vectors Group");
shapeGrp = contentGrp.addProperty("ADBE Vector Group");
shapeGrp.name = "Triangle";
contentsGrp = shapeGrp.property("ADBE Vectors Group");
pt3d = shapeLayer.Effects.addProperty("ADBE Point3D Control");
pt3dProp = pt3d.property(1);
pathGrp = contentsGrp.addProperty("ADBE Vector Shape - Group");
pathProp = pathGrp.property("ADBE Vector Shape");
keyTimes = [];
keyShapeValues = [];
keyPosValues = [];
startT = comp.workAreaStart;
endT = (comp.workAreaStart + comp.workAreaDuration) + 0.005000;
for(t = startT;t < endT;t += comp.frameDuration)
{
shapeLayer.position.expression = ((((((((((("LA = thisComp.layer(\"" + layerA.name) + "\");\r") + "LB = thisComp.layer(\"") + layerB.name) + "\");\r") + "LC = thisComp.layer(\"") + layerC.name) + "\");\r") + "a = LA.toWorld(LA.anchorPoint);\r") + "b = LB.toWorld(LB.anchorPoint);\r") + "c = LC.toWorld(LC.anchorPoint);\r") + "(a + b + c) / 3;";
pos = shapeLayer.position.valueAtTime(t,false);
shape = new Shape();
verts = [];
pt3dProp.expression = (("L = thisComp.layer(\"" + layerA.name) + "\");\r") + "fromWorld(L.toWorld(L.anchorPoint));";
v0 = pt3dProp.valueAtTime(t,false);
v0.pop();
pt3dProp.expression = (("L = thisComp.layer(\"" + layerB.name) + "\");\r") + "fromWorld(L.toWorld(L.anchorPoint));";
v1 = pt3dProp.valueAtTime(t,false);
v1.pop();
pt3dProp.expression = (("L = thisComp.layer(\"" + layerC.name) + "\");\r") + "fromWorld(L.toWorld(L.anchorPoint));";
v2 = pt3dProp.valueAtTime(t,false);
v2.pop();
verts.push(v0);
verts.push(v1);
verts.push(v2);
shape.vertices = verts;
shape.closed = true;
keyTimes.push(t);
keyShapeValues.push(shape);
keyPosValues.push(pos);
}
pt3d.remove();
shapeLayer.position.expression = "";
shapeLayer.position.setValuesAtTimes(keyTimes,keyPosValues);
pathProp.setValuesAtTimes(keyTimes,keyShapeValues);
strokeGrp = contentsGrp.addProperty("ADBE Vector Graphic - Stroke");
strokeWidthProp = strokeGrp.property("ADBE Vector Stroke Width");
strokeWidthProp.setValue(strokeWidth);
fillGrp = contentsGrp.addProperty("ADBE Vector Graphic - Fill");
fillColorProp = fillGrp.property("ADBE Vector Fill Color");
if(useColorsFromLayerB)
{
fillColorProp.expression = ((("L = thisComp.layer(\"" + useColorsFromLayerName) + "\");\r") + "pt = L.fromCompToSurface(toWorld(anchorPoint));\r") + "L.sampleImage(pt);";
}
else
{
fillColorProp.setValue(strokeColor);
}
}
};
this.createAboutDlg = function (aboutStr,usageStr)
{
{
eval(unescape("%09%09%76%61%72%20%64%6C%67%20%3D%20%6E%65%77%20%57%69%6E%64%6F%77%28%22%64%69%61%6C%6F%67%22%2C%20%22%41%62%6F%75%74%22%29%3B%0A%09%20%20%20%20%20%20%09%20%20%20%20%20%20%20%09%0A%09%20%20%20%20%76%61%72%20%72%65%73%20%3D%0A%09%09%22%67%72%6F%75%70%20%7B%20%6F%72%69%65%6E%74%61%74%69%6F%6E%3A%27%63%6F%6C%75%6D%6E%27%2C%20%61%6C%69%67%6E%6D%65%6E%74%3A%5B%27%66%69%6C%6C%27%2C%27%66%69%6C%6C%27%5D%2C%20%61%6C%69%67%6E%43%68%69%6C%64%72%65%6E%3A%5B%27%66%69%6C%6C%27%2C%27%66%69%6C%6C%27%5D%2C%20%5C%0A%09%09%09%70%6E%6C%3A%20%50%61%6E%65%6C%20%7B%20%74%79%70%65%3A%27%74%61%62%62%65%64%70%61%6E%65%6C%27%2C%20%5C%0A%09%09%09%09%61%62%6F%75%74%54%61%62%3A%20%50%61%6E%65%6C%20%7B%20%74%79%70%65%3A%27%74%61%62%27%2C%20%74%65%78%74%3A%27%44%65%73%63%72%69%70%74%69%6F%6E%27%2C%20%5C%0A%09%09%09%09%09%61%62%6F%75%74%45%74%3A%20%45%64%69%74%54%65%78%74%20%7B%20%74%65%78%74%3A%27%22%20%2B%20%74%68%69%73%2E%6C%6F%63%28%61%62%6F%75%74%53%74%72%29%20%2B%20%22%27%2C%20%70%72%65%66%65%72%72%65%64%53%69%7A%65%3A%5B%33%36%30%2C%32%30%30%5D%2C%20%70%72%6F%70%65%72%74%69%65%73%3A%7B%6D%75%6C%74%69%6C%69%6E%65%3A%74%72%75%65%7D%20%7D%20%5C%0A%09%09%09%09%7D%2C%20%5C%0A%09%09%09%09%75%73%61%67%65%54%61%62%3A%20%50%61%6E%65%6C%20%7B%20%74%79%70%65%3A%27%74%61%62%27%2C%20%74%65%78%74%3A%27%55%73%61%67%65%27%2C%20%5C%0A%09%09%09%09%09%75%73%61%67%65%45%74%3A%20%45%64%69%74%54%65%78%74%20%7B%20%74%65%78%74%3A%27%22%20%2B%20%74%68%69%73%2E%6C%6F%63%28%75%73%61%67%65%53%74%72%29%20%2B%20%22%27%2C%20%70%72%65%66%65%72%72%65%64%53%69%7A%65%3A%5B%33%36%30%2C%32%30%30%5D%2C%20%70%72%6F%70%65%72%74%69%65%73%3A%7B%6D%75%6C%74%69%6C%69%6E%65%3A%74%72%75%65%7D%20%7D%20%5C%0A%09%09%09%09%7D%20%5C%0A%09%09%09%7D%2C%20%5C%0A%09%09%09%62%74%6E%73%3A%20%47%72%6F%75%70%20%7B%20%6F%72%69%65%6E%74%61%74%69%6F%6E%3A%27%72%6F%77%27%2C%20%61%6C%69%67%6E%6D%65%6E%74%3A%5B%27%66%69%6C%6C%27%2C%27%62%6F%74%74%6F%6D%27%5D%2C%20%5C%0A%09%09%09%09%6F%74%68%65%72%53%63%72%69%70%74%73%42%74%6E%3A%20%42%75%74%74%6F%6E%20%7B%20%74%65%78%74%3A%27%4F%74%68%65%72%20%53%63%72%69%70%74%73%2E%2E%2E%27%2C%20%61%6C%69%67%6E%6D%65%6E%74%3A%5B%27%6C%65%66%74%27%2C%27%63%65%6E%74%65%72%27%5D%20%7D%2C%20%5C%0A%09%09%09%09%6F%6B%42%74%6E%3A%20%42%75%74%74%6F%6E%20%7B%20%74%65%78%74%3A%27%4F%6B%27%2C%20%61%6C%69%67%6E%6D%65%6E%74%3A%5B%27%72%69%67%68%74%27%2C%27%63%65%6E%74%65%72%27%5D%20%7D%20%5C%0A%09%09%09%7D%20%5C%0A%09%09%7D%22%3B%20%0A%09%09%64%6C%67%2E%67%72%20%3D%20%64%6C%67%2E%61%64%64%28%72%65%73%29%3B%0A%09%09%0A%09%09%64%6C%67%2E%67%72%2E%70%6E%6C%2E%61%62%6F%75%74%54%61%62%2E%61%62%6F%75%74%45%74%2E%6F%6E%43%68%61%6E%67%65%20%3D%20%64%6C%67%2E%67%72%2E%70%6E%6C%2E%61%62%6F%75%74%54%61%62%2E%61%62%6F%75%74%45%74%2E%6F%6E%43%68%61%6E%67%69%6E%67%20%3D%20%66%75%6E%63%74%69%6F%6E%20%28%29%0A%09%09%7B%0A%09%09%09%74%68%69%73%2E%74%65%78%74%20%3D%20%75%74%69%6C%73%2E%6C%6F%63%28%61%62%6F%75%74%53%74%72%29%2E%72%65%70%6C%61%63%65%28%2F%5C%5C%72%2F%67%2C%20%27%5C%72%27%29%3B%0A%09%09%7D%3B%0A%09%09%0A%09%09%64%6C%67%2E%67%72%2E%70%6E%6C%2E%75%73%61%67%65%54%61%62%2E%75%73%61%67%65%45%74%2E%6F%6E%43%68%61%6E%67%65%20%3D%20%64%6C%67%2E%67%72%2E%70%6E%6C%2E%75%73%61%67%65%54%61%62%2E%75%73%61%67%65%45%74%2E%6F%6E%43%68%61%6E%67%69%6E%67%20%3D%20%66%75%6E%63%74%69%6F%6E%20%28%29%0A%09%09%7B%0A%09%09%09%74%68%69%73%2E%74%65%78%74%20%3D%20%75%74%69%6C%73%2E%6C%6F%63%28%75%73%61%67%65%53%74%72%29%2E%72%65%70%6C%61%63%65%28%2F%5C%5C%72%2F%67%2C%20%27%5C%72%27%29%2E%72%65%70%6C%61%63%65%28%2F%5C%5C%27%2F%67%2C%20%22%27%22%29%3B%0A%09%09%7D%3B%0A%09%09%09%0A%09%09%64%6C%67%2E%67%72%2E%62%74%6E%73%2E%6F%74%68%65%72%53%63%72%69%70%74%73%42%74%6E%2E%6F%6E%43%6C%69%63%6B%20%3D%20%66%75%6E%63%74%69%6F%6E%20%28%29%0A%09%09%7B%0A%09%09%09%76%61%72%20%63%6D%64%20%3D%20%22%22%3B%0A%09%09%09%76%61%72%20%75%72%6C%20%3D%20%22%68%74%74%70%3A%2F%2F%77%77%77%2E%6D%6F%74%69%6F%6E%62%6F%75%74%69%71%75%65%2E%63%6F%6D%22%3B%0A%09%0A%09%09%09%69%66%20%28%24%2E%6F%73%2E%69%6E%64%65%78%4F%66%28%22%57%69%6E%22%29%20%21%3D%20%2D%31%29%0A%09%09%09%7B%0A%09%20%20%20%20%20%20%20%20%09%69%66%20%28%46%69%6C%65%28%22%43%3A%2F%50%72%6F%67%72%61%6D%20%46%69%6C%65%73%2F%4D%6F%7A%69%6C%6C%61%20%46%69%72%65%66%6F%78%2F%66%69%72%65%66%6F%78%2E%65%78%65%22%29%2E%65%78%69%73%74%73%29%0A%09%09%09%09%09%63%6D%64%20%2B%3D%20%22%43%3A%2F%50%72%6F%67%72%61%6D%20%46%69%6C%65%73%2F%4D%6F%7A%69%6C%6C%61%20%46%69%72%65%66%6F%78%2F%66%69%72%65%66%6F%78%2E%65%78%65%20%22%20%2B%20%75%72%6C%3B%0A%09%09%09%09%65%6C%73%65%20%69%66%20%28%46%69%6C%65%28%22%43%3A%2F%50%72%6F%67%72%61%6D%20%46%69%6C%65%73%20%28%78%38%36%29%2F%4D%6F%7A%69%6C%6C%61%20%46%69%72%65%66%6F%78%2F%66%69%72%65%66%6F%78%2E%65%78%65%22%29%2E%65%78%69%73%74%73%29%0A%09%09%09%09%09%63%6D%64%20%2B%3D%20%22%43%3A%2F%50%72%6F%67%72%61%6D%20%46%69%6C%65%73%20%28%78%38%36%29%2F%4D%6F%7A%69%6C%6C%61%20%46%69%72%65%66%6F%78%2F%66%69%72%65%66%6F%78%2E%65%78%65%20%22%20%2B%20%75%72%6C%3B%0A%09%09%09%09%65%6C%73%65%0A%09%09%09%09%09%63%6D%64%20%2B%3D%20%22%43%3A%2F%50%72%6F%67%72%61%6D%20%46%69%6C%65%73%2F%49%6E%74%65%72%6E%65%74%20%45%78%70%6C%6F%72%65%72%2F%69%65%78%70%6C%6F%72%65%2E%65%78%65%20%22%20%2B%20%75%72%6C%3B%0A%09%09%09%7D%0A%09%09%09%65%6C%73%65%0A%09%09%09%09%63%6D%64%20%2B%3D%20%22%6F%70%65%6E%20%5C%22%22%20%2B%20%75%72%6C%20%2B%20%22%5C%22%22%3B%20%20%20%20%20%20%20%20%20%0A%09%09%09%74%72%79%0A%09%09%09%7B%0A%09%09%09%09%73%79%73%74%65%6D%2E%63%61%6C%6C%53%79%73%74%65%6D%28%63%6D%64%29%3B%0A%09%09%09%7D%0A%09%09%09%63%61%74%63%68%28%65%29%0A%09%09%09%7B%0A%09%09%09%09%61%6C%65%72%74%28%65%29%3B%0A%09%09%09%7D%0A%09%09%7D%3B%0A%09%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%0A%09%09%64%6C%67%2E%67%72%2E%62%74%6E%73%2E%6F%6B%42%74%6E%2E%6F%6E%43%6C%69%63%6B%20%3D%20%66%75%6E%63%74%69%6F%6E%20%28%29%20%0A%09%09%7B%0A%09%09%09%64%6C%67%2E%63%6C%6F%73%65%28%29%3B%20%0A%09%09%7D%3B%0A%09%20%20%20%20%20%20%20%0A%09%09%64%6C%67%2E%63%65%6E%74%65%72%28%29%3B%0A%09%09%64%6C%67%2E%73%68%6F%77%28%29%3B"));
}
};
}
}
function toWorld(layer,point,time)
{
{
eval(unescape("%09%09%2F%2F%20%72%65%74%75%72%6E%73%20%74%68%65%20%67%69%76%65%6E%20%61%6E%67%6C%65%20%69%6E%20%72%61%64%69%61%6E%73%0A%09%09%66%75%6E%63%74%69%6F%6E%20%64%65%67%54%6F%52%61%64%28%64%65%67%29%0A%09%09%7B%0A%09%09%09%72%65%74%75%72%6E%20%64%65%67%20%2A%20%4D%61%74%68%2E%50%49%20%2F%20%31%38%30%3B%09%0A%09%09%7D%0A%0A%09%09%2F%2F%20%72%65%74%75%72%6E%73%20%63%6F%73%69%6E%75%73%20%6F%66%20%74%68%65%20%67%69%76%65%6E%20%61%6E%67%6C%65%20%28%69%6E%20%72%61%64%69%61%6E%73%29%0A%09%09%66%75%6E%63%74%69%6F%6E%20%63%28%61%6E%67%6C%65%29%0A%09%09%7B%0A%09%09%09%72%65%74%75%72%6E%20%4D%61%74%68%2E%63%6F%73%28%61%6E%67%6C%65%29%3B%0A%09%09%7D%0A%0A%09%09%2F%2F%20%72%65%74%75%72%6E%73%20%73%69%6E%75%73%20%6F%66%20%74%68%65%20%67%69%76%65%6E%20%61%6E%67%6C%65%20%28%69%6E%20%72%61%64%69%61%6E%73%29%0A%09%09%66%75%6E%63%74%69%6F%6E%20%73%28%61%6E%67%6C%65%29%0A%09%09%7B%0A%09%09%09%72%65%74%75%72%6E%20%4D%61%74%68%2E%73%69%6E%28%61%6E%67%6C%65%29%3B%0A%09%09%7D%0A%0A%09%09%2F%2F%20%72%65%74%75%72%6E%73%20%33%44%20%76%65%63%74%6F%72%20%66%69%6C%6C%65%64%20%77%69%74%68%20%74%68%65%20%67%69%76%65%6E%20%65%6C%65%6D%65%6E%74%73%0A%09%09%66%75%6E%63%74%69%6F%6E%20%76%65%63%33%28%76%30%2C%76%31%2C%76%32%29%0A%09%09%7B%0A%09%09%09%76%61%72%20%76%20%3D%20%6E%65%77%20%41%72%72%61%79%28%33%29%3B%09%0A%09%09%09%76%5B%30%5D%20%3D%20%76%30%2C%20%76%5B%31%5D%20%3D%20%76%31%3B%20%76%5B%32%5D%20%3D%20%76%32%3B%0A%09%09%09%72%65%74%75%72%6E%20%76%3B%0A%09%09%7D%0A%0A%09%09%2F%2F%20%72%65%74%75%72%6E%73%20%33%78%33%20%6D%61%74%72%69%78%20%66%69%6C%6C%65%64%20%77%69%74%68%20%74%68%65%20%67%69%76%65%6E%20%65%6C%65%6D%65%6E%74%73%0A%09%09%66%75%6E%63%74%69%6F%6E%20%6D%61%74%72%69%78%33%28%6D%30%30%2C%6D%30%31%2C%6D%30%32%2C%6D%31%30%2C%6D%31%31%2C%6D%31%32%2C%6D%32%30%2C%6D%32%31%2C%6D%32%32%29%0A%09%09%7B%0A%09%09%09%76%61%72%20%4D%20%3D%20%6E%65%77%20%41%72%72%61%79%28%33%29%3B%09%0A%09%09%09%4D%5B%30%5D%20%3D%20%6E%65%77%20%41%72%72%61%79%28%33%29%3B%0A%09%09%09%4D%5B%31%5D%20%3D%20%6E%65%77%20%41%72%72%61%79%28%33%29%3B%0A%09%09%09%4D%5B%32%5D%20%3D%20%6E%65%77%20%41%72%72%61%79%28%33%29%3B%09%0A%09%09%09%4D%5B%30%5D%5B%30%5D%20%3D%20%6D%30%30%3B%09%4D%5B%30%5D%5B%31%5D%20%3D%20%6D%30%31%3B%09%4D%5B%30%5D%5B%32%5D%20%3D%20%6D%30%32%3B%0A%09%09%09%4D%5B%31%5D%5B%30%5D%20%3D%20%6D%31%30%3B%09%4D%5B%31%5D%5B%31%5D%20%3D%20%6D%31%31%3B%09%4D%5B%31%5D%5B%32%5D%20%3D%20%6D%31%32%3B%0A%09%09%09%4D%5B%32%5D%5B%30%5D%20%3D%20%6D%32%30%3B%09%4D%5B%32%5D%5B%31%5D%20%3D%20%6D%32%31%3B%09%4D%5B%32%5D%5B%32%5D%20%3D%20%6D%32%32%3B%09%0A%09%09%09%72%65%74%75%72%6E%20%4D%3B%0A%09%09%7D%0A%0A%09%09%2F%2F%20%72%65%74%75%72%6E%73%20%33%44%20%76%65%63%74%6F%72%20%6F%62%74%61%69%6E%65%64%20%62%79%20%6D%75%6C%74%69%70%6C%79%69%6E%67%20%63%6F%6D%70%6F%6E%65%6E%74%73%20%6F%66%20%74%68%65%20%74%77%6F%20%67%69%76%65%6E%20%76%65%63%74%6F%72%73%0A%09%09%66%75%6E%63%74%69%6F%6E%20%6D%75%6C%74%56%65%63%33%56%65%63%33%28%76%31%2C%76%32%29%0A%09%09%7B%0A%09%09%09%72%65%74%75%72%6E%20%76%65%63%33%28%76%31%5B%30%5D%20%2A%20%76%32%5B%30%5D%2C%76%31%5B%31%5D%20%2A%20%76%32%5B%31%5D%2C%76%31%5B%32%5D%20%2A%20%76%32%5B%32%5D%29%3B%0A%09%09%7D%0A%0A%09%09%2F%2F%20%72%65%74%75%72%6E%73%20%33%44%20%76%65%63%74%6F%72%20%6F%62%74%61%69%6E%65%64%20%62%79%20%6D%75%6C%74%69%70%6C%79%69%6E%67%20%74%68%65%20%67%69%76%65%6E%20%33%78%33%20%6D%61%74%72%69%78%20%62%79%20%74%68%65%20%67%69%76%65%6E%20%33%44%20%76%65%63%74%6F%72%0A%09%09%66%75%6E%63%74%69%6F%6E%20%6D%75%6C%74%4D%61%74%33%56%65%63%33%28%4D%2C%76%29%0A%09%09%7B%0A%09%09%09%76%61%72%20%76%30%20%3D%20%4D%5B%30%5D%5B%30%5D%20%2A%20%76%5B%30%5D%20%2B%20%4D%5B%30%5D%5B%31%5D%20%2A%20%76%5B%31%5D%20%2B%20%4D%5B%30%5D%5B%32%5D%20%2A%20%76%5B%32%5D%3B%0A%09%09%09%76%61%72%20%76%31%20%3D%20%4D%5B%31%5D%5B%30%5D%20%2A%20%76%5B%30%5D%20%2B%20%4D%5B%31%5D%5B%31%5D%20%2A%20%76%5B%31%5D%20%2B%20%4D%5B%31%5D%5B%32%5D%20%2A%20%76%5B%32%5D%3B%0A%09%09%09%76%61%72%20%76%32%20%3D%20%4D%5B%32%5D%5B%30%5D%20%2A%20%76%5B%30%5D%20%2B%20%4D%5B%32%5D%5B%31%5D%20%2A%20%76%5B%31%5D%20%2B%20%4D%5B%32%5D%5B%32%5D%20%2A%20%76%5B%32%5D%3B%0A%09%09%09%72%65%74%75%72%6E%20%76%65%63%33%28%76%30%2C%76%31%2C%76%32%29%3B%0A%09%09%7D%0A%0A%09%09%2F%2F%20%72%65%74%75%72%6E%73%20%33%78%33%20%6D%61%74%72%69%78%20%6F%62%74%61%69%6E%65%64%20%62%79%20%6D%75%6C%74%69%70%6C%79%69%6E%67%20%74%68%65%20%74%77%6F%20%67%69%76%65%6E%20%33%78%33%20%6D%61%74%72%69%63%65%73%0A%09%09%66%75%6E%63%74%69%6F%6E%20%6D%75%6C%74%4D%61%74%33%4D%61%74%33%28%4D%31%2C%4D%32%29%0A%09%09%7B%0A%09%09%09%76%61%72%20%4D%33%20%3D%20%6D%61%74%72%69%78%33%28%30%2C%30%2C%30%2C%30%2C%30%2C%30%2C%30%2C%30%2C%30%29%3B%0A%09%09%09%66%6F%72%20%28%76%61%72%20%69%20%3D%20%30%3B%20%69%20%3C%20%33%3B%20%69%2B%2B%29%0A%09%09%09%66%6F%72%20%28%76%61%72%20%6A%20%3D%20%30%3B%20%6A%20%3C%20%33%3B%20%6A%2B%2B%29%0A%09%09%09%66%6F%72%20%28%76%61%72%20%6B%20%3D%20%30%3B%20%6B%20%3C%20%33%3B%20%6B%2B%2B%29%0A%09%09%09%7B%0A%09%09%09%09%4D%33%5B%69%5D%5B%6A%5D%20%2B%3D%20%4D%31%5B%69%5D%5B%6B%5D%20%2A%20%4D%32%5B%6B%5D%5B%6A%5D%3B%09%09%0A%09%09%09%7D%0A%09%09%09%72%65%74%75%72%6E%20%4D%33%3B%0A%09%09%7D%0A%0A%09%09%2F%2F%20%72%65%74%75%72%6E%73%20%33%44%20%70%6F%69%6E%74%20%6F%62%74%61%69%6E%65%64%20%62%79%20%72%6F%74%61%74%69%6E%67%20%74%68%65%20%67%69%76%65%6E%20%70%6F%69%6E%74%20%61%62%6F%75%74%20%74%68%65%20%78%2D%61%78%69%73%0A%09%09%66%75%6E%63%74%69%6F%6E%20%72%6F%74%61%74%65%50%6F%69%6E%74%41%62%6F%75%74%58%28%70%2C%61%6E%67%6C%65%29%0A%09%09%7B%0A%09%09%09%76%61%72%20%6E%65%77%70%20%3D%20%70%3B%09%0A%09%09%09%76%61%72%20%61%20%3D%20%64%65%67%54%6F%52%61%64%28%61%6E%67%6C%65%29%3B%09%0A%09%09%09%69%66%20%28%61%20%21%3D%20%30%29%0A%09%09%09%7B%0A%09%09%09%09%6E%65%77%70%20%3D%20%6D%75%6C%74%4D%61%74%33%56%65%63%33%28%6D%61%74%72%69%78%33%28%31%2C%30%2C%30%2C%30%2C%63%28%61%29%2C%2D%73%28%61%29%2C%30%2C%73%28%61%29%2C%63%28%61%29%29%2C%70%29%3B%0A%09%09%09%7D%09%0A%09%09%09%72%65%74%75%72%6E%20%6E%65%77%70%3B%0A%09%09%7D%0A%0A%09%09%2F%2F%20%72%65%74%75%72%6E%73%20%33%44%20%70%6F%69%6E%74%20%6F%62%74%61%69%6E%65%64%20%62%79%20%72%6F%74%61%74%69%6E%67%20%74%68%65%20%67%69%76%65%6E%20%70%6F%69%6E%74%20%61%62%6F%75%74%20%74%68%65%20%79%2D%61%78%69%73%0A%09%09%66%75%6E%63%74%69%6F%6E%20%72%6F%74%61%74%65%50%6F%69%6E%74%41%62%6F%75%74%59%28%70%2C%61%6E%67%6C%65%29%0A%09%09%7B%0A%09%09%09%76%61%72%20%6E%65%77%70%20%3D%20%70%3B%09%0A%09%09%09%76%61%72%20%61%20%3D%20%64%65%67%54%6F%52%61%64%28%61%6E%67%6C%65%29%3B%09%0A%09%09%09%69%66%20%28%61%20%21%3D%20%30%29%0A%09%09%09%7B%0A%09%09%09%09%6E%65%77%70%20%3D%20%6D%75%6C%74%4D%61%74%33%56%65%63%33%28%6D%61%74%72%69%78%33%28%63%28%61%29%2C%30%2C%73%28%61%29%2C%30%2C%31%2C%30%2C%2D%73%28%61%29%2C%30%2C%63%28%61%29%29%2C%70%29%3B%0A%09%09%09%7D%09%0A%09%09%09%72%65%74%75%72%6E%20%6E%65%77%70%3B%0A%09%09%7D%0A%0A%09%09%2F%2F%20%72%65%74%75%72%6E%73%20%33%44%20%70%6F%69%6E%74%20%6F%62%74%61%69%6E%65%64%20%62%79%20%72%6F%74%61%74%69%6E%67%20%74%68%65%20%67%69%76%65%6E%20%70%6F%69%6E%74%20%61%62%6F%75%74%20%74%68%65%20%7A%2D%61%78%69%73%0A%09%09%66%75%6E%63%74%69%6F%6E%20%72%6F%74%61%74%65%50%6F%69%6E%74%41%62%6F%75%74%5A%28%70%2C%61%6E%67%6C%65%29%0A%09%09%7B%0A%09%09%09%76%61%72%20%6E%65%77%70%20%3D%20%70%3B%09%0A%09%09%09%76%61%72%20%61%20%3D%20%64%65%67%54%6F%52%61%64%28%61%6E%67%6C%65%29%3B%09%0A%09%09%09%69%66%20%28%61%20%21%3D%20%30%29%0A%09%09%09%7B%0A%09%09%09%09%6E%65%77%70%20%3D%20%6D%75%6C%74%4D%61%74%33%56%65%63%33%28%6D%61%74%72%69%78%33%28%63%28%61%29%2C%2D%73%28%61%29%2C%30%2C%73%28%61%29%2C%63%28%61%29%2C%30%2C%30%2C%30%2C%31%29%2C%70%29%3B%0A%09%09%09%7D%09%0A%09%09%09%72%65%74%75%72%6E%20%6E%65%77%70%3B%0A%09%09%7D%0A%0A%09%09%2F%2F%20%72%65%74%75%72%6E%73%20%33%44%20%70%6F%69%6E%74%20%6F%62%74%61%69%6E%65%64%20%62%79%20%72%6F%74%61%74%69%6E%67%20%74%68%65%20%67%69%76%65%6E%20%70%6F%69%6E%74%20%61%62%6F%75%74%20%74%68%65%20%78%2F%79%2F%7A%2D%61%78%69%73%0A%09%09%66%75%6E%63%74%69%6F%6E%20%72%6F%74%61%74%65%50%6F%69%6E%74%41%62%6F%75%74%58%59%5A%28%70%2C%61%6E%67%6C%65%58%2C%61%6E%67%6C%65%59%2C%61%6E%67%6C%65%5A%29%0A%09%09%7B%0A%09%09%09%76%61%72%20%6E%65%77%70%20%3D%20%70%3B%0A%09%09%09%69%66%20%28%61%6E%67%6C%65%5A%20%21%3D%20%30%29%0A%09%09%09%7B%0A%09%09%09%09%6E%65%77%70%20%3D%20%72%6F%74%61%74%65%50%6F%69%6E%74%41%62%6F%75%74%5A%28%6E%65%77%70%2C%61%6E%67%6C%65%5A%29%3B%0A%09%09%09%7D%0A%09%09%09%69%66%20%28%61%6E%67%6C%65%59%20%21%3D%20%30%29%0A%09%09%09%7B%0A%09%09%09%09%6E%65%77%70%20%3D%20%72%6F%74%61%74%65%50%6F%69%6E%74%41%62%6F%75%74%59%28%6E%65%77%70%2C%61%6E%67%6C%65%59%29%3B%0A%09%09%09%7D%0A%09%09%09%69%66%20%28%61%6E%67%6C%65%58%20%21%3D%20%30%29%0A%09%09%09%7B%0A%09%09%09%09%6E%65%77%70%20%3D%20%72%6F%74%61%74%65%50%6F%69%6E%74%41%62%6F%75%74%58%28%6E%65%77%70%2C%61%6E%67%6C%65%58%29%3B%0A%09%09%09%7D%0A%09%09%09%72%65%74%75%72%6E%20%6E%65%77%70%3B%09%0A%09%09%7D%0A%0A%09%09%2F%2F%20%72%65%74%75%72%6E%73%20%33%44%20%70%6F%69%6E%74%20%6F%62%74%61%69%6E%65%64%20%62%79%20%72%6F%74%61%74%69%6E%67%20%74%68%65%20%67%69%76%65%6E%20%70%6F%69%6E%74%20%61%62%6F%75%74%20%74%68%65%20%78%2F%79%2F%7A%2D%61%78%69%73%0A%09%09%66%75%6E%63%74%69%6F%6E%20%6F%72%69%65%6E%74%50%6F%69%6E%74%41%62%6F%75%74%58%59%5A%28%70%2C%6F%72%69%29%0A%09%09%7B%0A%09%09%09%72%65%74%75%72%6E%20%72%6F%74%61%74%65%50%6F%69%6E%74%41%62%6F%75%74%58%59%5A%28%70%2C%6F%72%69%5B%30%5D%2C%6F%72%69%5B%31%5D%2C%6F%72%69%5B%32%5D%29%3B%0A%09%09%7D%0A%0A%09%09%2F%2F%20%72%65%74%75%72%6E%73%20%70%69%78%65%6C%20%61%73%70%65%63%74%20%72%61%74%69%6F%20%6F%66%20%74%68%65%20%67%69%76%65%6E%20%6C%61%79%65%72%0A%09%09%66%75%6E%63%74%69%6F%6E%20%67%65%74%50%61%72%28%6C%61%79%65%72%29%0A%09%09%7B%0A%09%09%09%76%61%72%20%70%61%72%20%3D%20%6C%61%79%65%72%2E%73%6F%75%72%63%65%20%3F%20%6C%61%79%65%72%2E%73%6F%75%72%63%65%2E%70%69%78%65%6C%41%73%70%65%63%74%20%3A%20%31%3B%0A%09%09%09%69%66%20%28%6C%61%79%65%72%2E%61%64%6A%75%73%74%6D%65%6E%74%4C%61%79%65%72%29%0A%09%09%09%7B%0A%09%09%09%09%70%61%72%20%3D%20%6C%61%79%65%72%2E%63%6F%6E%74%61%69%6E%69%6E%67%43%6F%6D%70%2E%70%69%78%65%6C%41%73%70%65%63%74%3B%0A%09%09%09%7D%09%0A%09%09%09%72%65%74%75%72%6E%20%70%61%72%3B%0A%09%09%7D%0A%0A%09%09%2F%2F%20%72%65%74%75%72%6E%73%20%61%63%63%75%72%61%74%65%20%76%61%6C%75%65%20%6F%66%20%74%68%65%20%67%69%76%65%6E%20%70%69%78%65%6C%20%61%73%70%65%63%74%20%72%61%74%69%6F%0A%09%09%66%75%6E%63%74%69%6F%6E%20%67%65%74%41%63%63%75%72%61%74%65%28%70%61%72%29%0A%09%09%7B%0A%09%09%09%76%61%72%20%61%63%63%50%61%72%3B%0A%09%09%09%73%77%69%74%63%68%28%70%61%72%29%0A%09%09%09%7B%0A%09%09%09%09%63%61%73%65%20%30%2E%39%3A%0A%09%09%09%09%09%61%63%63%50%61%72%20%3D%20%30%2E%39%3B%0A%09%09%09%09%09%62%72%65%61%6B%3B%0A%09%09%09%09%63%61%73%65%20%31%3A%0A%09%09%09%09%09%61%63%63%50%61%72%20%3D%20%31%3B%0A%09%09%09%09%09%62%72%65%61%6B%3B%0A%09%09%09%09%63%61%73%65%20%31%2E%30%37%3A%0A%09%09%09%09%09%61%63%63%50%61%72%20%3D%20%31%2E%30%36%36%36%36%36%36%36%36%36%36%36%36%36%37%3B%0A%09%09%09%09%09%62%72%65%61%6B%3B%0A%09%09%09%09%63%61%73%65%20%31%2E%32%3A%0A%09%09%09%09%09%61%63%63%50%61%72%20%3D%20%31%2E%32%3B%0A%09%09%09%09%09%62%72%65%61%6B%3B%0A%09%09%09%09%63%61%73%65%20%31%2E%33%33%3A%0A%09%09%09%09%09%61%63%63%50%61%72%20%3D%20%31%2E%33%33%33%33%33%33%33%33%33%33%33%33%33%33%33%3B%0A%09%09%09%09%09%62%72%65%61%6B%3B%09%09%09%0A%09%09%09%09%63%61%73%65%20%31%2E%34%32%3A%0A%09%09%09%09%09%61%63%63%50%61%72%20%3D%20%31%2E%34%32%32%32%32%32%32%32%32%32%32%32%32%32%32%3B%0A%09%09%09%09%09%62%72%65%61%6B%3B%09%0A%09%09%09%09%63%61%73%65%20%31%2E%35%3A%0A%09%09%09%09%09%61%63%63%50%61%72%20%3D%20%31%2E%35%3B%0A%09%09%09%09%09%62%72%65%61%6B%3B%0A%09%09%09%09%63%61%73%65%20%32%3A%0A%09%09%09%09%09%61%63%63%50%61%72%20%3D%20%32%3B%0A%09%09%09%09%09%62%72%65%61%6B%3B%09%0A%09%09%09%09%64%65%66%61%75%6C%74%3A%0A%09%09%09%09%09%61%63%63%50%61%72%20%3D%20%31%3B%0A%09%09%09%09%09%62%72%65%61%6B%3B%0A%09%09%09%7D%0A%09%09%09%72%65%74%75%72%6E%20%61%63%63%50%61%72%3B%0A%09%09%7D%0A%0A%09%09%2F%2F%20%72%65%74%75%72%6E%73%20%76%61%6C%75%65%20%6F%66%20%74%68%65%20%67%69%76%65%6E%20%74%72%61%6E%73%66%6F%72%6D%20%70%72%6F%70%65%72%74%79%20%28%70%6F%73%74%2D%65%78%70%72%65%73%73%69%6F%6E%20%76%61%6C%75%65%29%0A%09%09%66%75%6E%63%74%69%6F%6E%20%67%65%74%54%72%61%6E%73%56%61%6C%75%65%41%74%43%6F%6D%70%54%69%6D%65%28%6C%61%79%65%72%2C%74%72%61%6E%73%4E%61%6D%65%29%0A%09%09%7B%0A%09%09%09%72%65%74%75%72%6E%20%6C%61%79%65%72%2E%70%72%6F%70%65%72%74%79%28%74%72%61%6E%73%4E%61%6D%65%29%2E%76%61%6C%75%65%41%74%54%69%6D%65%28%74%69%6D%65%2C%66%61%6C%73%65%29%3B%0A%09%09%7D%0A%09%09%0A%09%09%66%75%6E%63%74%69%6F%6E%20%67%65%74%52%65%73%75%6C%74%28%29%0A%09%09%7B%0A%09%09%09%2F%2F%20%72%65%74%72%69%65%76%65%73%20%6C%61%79%65%72%20%74%72%61%6E%73%66%6F%72%6D%73%0A%09%09%09%76%61%72%20%61%6E%63%20%3D%20%67%65%74%54%72%61%6E%73%56%61%6C%75%65%41%74%43%6F%6D%70%54%69%6D%65%28%6C%61%79%65%72%2C%22%61%6E%63%68%6F%72%50%6F%69%6E%74%22%29%3B%0A%09%09%09%76%61%72%20%70%6F%73%20%3D%20%67%65%74%54%72%61%6E%73%56%61%6C%75%65%41%74%43%6F%6D%70%54%69%6D%65%28%6C%61%79%65%72%2C%22%70%6F%73%69%74%69%6F%6E%22%29%3B%0A%09%09%09%76%61%72%20%73%63%61%20%3D%20%67%65%74%54%72%61%6E%73%56%61%6C%75%65%41%74%43%6F%6D%70%54%69%6D%65%28%6C%61%79%65%72%2C%22%73%63%61%6C%65%22%29%3B%0A%09%09%09%76%61%72%20%6F%72%69%20%3D%20%67%65%74%54%72%61%6E%73%56%61%6C%75%65%41%74%43%6F%6D%70%54%69%6D%65%28%6C%61%79%65%72%2C%22%6F%72%69%65%6E%74%61%74%69%6F%6E%22%29%3B%0A%09%09%09%76%61%72%20%72%6F%78%20%3D%20%67%65%74%54%72%61%6E%73%56%61%6C%75%65%41%74%43%6F%6D%70%54%69%6D%65%28%6C%61%79%65%72%2C%22%72%6F%74%61%74%69%6F%6E%58%22%29%3B%0A%09%09%09%76%61%72%20%72%6F%79%20%3D%20%67%65%74%54%72%61%6E%73%56%61%6C%75%65%41%74%43%6F%6D%70%54%69%6D%65%28%6C%61%79%65%72%2C%22%72%6F%74%61%74%69%6F%6E%59%22%29%3B%0A%09%09%09%76%61%72%20%72%6F%7A%20%3D%20%67%65%74%54%72%61%6E%73%56%61%6C%75%65%41%74%43%6F%6D%70%54%69%6D%65%28%6C%61%79%65%72%2C%22%72%6F%74%61%74%69%6F%6E%5A%22%29%3B%0A%09%09%09%76%61%72%20%70%50%61%72%20%3D%20%67%65%74%41%63%63%75%72%61%74%65%28%6C%61%79%65%72%2E%70%61%72%65%6E%74%20%3F%20%67%65%74%50%61%72%28%6C%61%79%65%72%2E%70%61%72%65%6E%74%29%20%3A%20%6C%61%79%65%72%2E%63%6F%6E%74%61%69%6E%69%6E%67%43%6F%6D%70%2E%70%69%78%65%6C%41%73%70%65%63%74%29%3B%0A%09%09%09%76%61%72%20%6C%50%61%72%20%3D%20%67%65%74%41%63%63%75%72%61%74%65%28%67%65%74%50%61%72%28%6C%61%79%65%72%29%29%3B%0A%09%09%09%76%61%72%20%72%61%74%69%6F%20%3D%20%6C%50%61%72%20%2F%20%70%50%61%72%3B%0A%0A%09%09%09%2F%2F%20%69%6E%69%74%69%61%6C%69%7A%65%73%20%72%65%73%75%6C%74%69%6E%67%20%70%6F%69%6E%74%0A%09%09%09%76%61%72%20%6E%65%77%70%20%3D%20%70%6F%69%6E%74%3B%0A%0A%09%09%09%2F%2F%20%63%6F%6D%70%65%6E%73%61%74%65%73%20%61%6E%63%68%6F%72%20%70%6F%69%6E%74%0A%09%09%09%6E%65%77%70%20%2D%3D%20%61%6E%63%3B%0A%0A%09%09%09%2F%2F%20%73%63%61%6C%65%73%20%61%63%63%6F%72%64%69%6E%67%20%74%6F%20%70%69%78%65%6C%20%61%73%70%65%63%74%20%72%61%74%69%6F%0A%09%09%09%6E%65%77%70%20%3D%20%6D%75%6C%74%56%65%63%33%56%65%63%33%28%6E%65%77%70%2C%76%65%63%33%28%72%61%74%69%6F%20%2A%20%28%73%63%61%5B%30%5D%20%2F%20%31%30%30%29%2C%73%63%61%5B%31%5D%20%2F%20%31%30%30%2C%73%63%61%5B%32%5D%20%2F%20%31%30%30%29%29%3B%0A%09%09%09%6E%65%77%70%20%3D%20%6D%75%6C%74%56%65%63%33%56%65%63%33%28%6E%65%77%70%2C%76%65%63%33%28%70%50%61%72%2C%31%2C%31%29%29%3B%0A%0A%09%09%09%2F%2F%20%72%6F%74%61%74%65%73%0A%09%09%09%6E%65%77%70%20%3D%20%72%6F%74%61%74%65%50%6F%69%6E%74%41%62%6F%75%74%58%59%5A%28%6E%65%77%70%2C%72%6F%78%2C%72%6F%79%2C%72%6F%7A%29%3B%0A%09%09%09%6E%65%77%70%20%3D%20%6F%72%69%65%6E%74%50%6F%69%6E%74%41%62%6F%75%74%58%59%5A%28%6E%65%77%70%2C%6F%72%69%29%3B%0A%0A%09%09%09%2F%2F%20%73%63%61%6C%65%73%20%62%61%63%6B%0A%09%09%09%6E%65%77%70%20%3D%20%6D%75%6C%74%56%65%63%33%56%65%63%33%28%6E%65%77%70%2C%76%65%63%33%28%31%20%2F%20%70%50%61%72%2C%31%2C%31%29%29%3B%0A%0A%09%09%09%2F%2F%20%74%72%61%6E%73%6C%61%74%65%73%0A%09%09%09%6E%65%77%70%20%2B%3D%20%70%6F%73%3B%0A%0A%09%09%09%2F%2F%20%72%65%63%63%75%72%73%65%20%69%66%20%6C%61%79%65%72%20%68%61%73%20%70%61%72%65%6E%74%0A%09%09%09%69%66%20%28%6C%61%79%65%72%2E%70%61%72%65%6E%74%29%0A%09%09%09%7B%0A%09%09%09%09%6E%65%77%70%20%3D%20%74%6F%57%6F%72%6C%64%28%6C%61%79%65%72%2E%70%61%72%65%6E%74%2C%6E%65%77%70%2C%74%69%6D%65%29%3B%0A%09%09%09%7D%0A%09%09%09%72%65%74%75%72%6E%20%6E%65%77%70%3B%09%0A%09%09%7D"));
return  getResult();
}
}
new ConnectLayers().run(this);
}
